<?php namespace danog\MadelineProto\TL;
/** @internal Autogenerated using tools/TL/Builder.php */
use danog\MadelineProto\MTProto;
use danog\MadelineProto\Connection;
use danog\MadelineProto\MTProtoTools\PeerDatabase;
use danog\MadelineProto\MTProtoTools\ReferenceDatabase;
use danog\MadelineProto\MTProtoTools\MinDatabase;
use danog\MadelineProto\SecurityException;
use AssertionError;
use danog\MadelineProto\Lang;
final class SecretTLParser {
public function __construct(
            private readonly MTProto $API,
            private readonly Connection $connection,
            private readonly PeerDatabase $peerDatabase,
            private readonly ?ReferenceDatabase $referenceDatabase,
            private readonly ?MinDatabase $minDatabase,
        ) {}
            private  function err(mixed $stream): never {

            fseek($stream, -4, SEEK_CUR);
            throw new AssertionError("Unexpected ID ".bin2hex(fread($stream, 4)));
        
    }
    private  function gzdecode(mixed $stream): mixed {

            $res = fopen('php://memory', 'rw+b');
            fwrite($res, gzdecode(self::deserialize_string($stream)));
            rewind($res);
            return $res;
        
    }
    private  function gzdecode_vector(mixed $stream): mixed {

            $res = fopen('php://memory', 'rw+b');
            fwrite($res, gzdecode(self::deserialize_string($stream)));
            rewind($res);
            return match (stream_get_contents($stream, 4)) {
                'ĵ' => $stream,
                default => self::err($stream)
            };
        
    }
    private  function deserialize_bytes(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return new Types\Bytes($x);
        
    }
    private  function deserialize_string(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return $x;
        
    }
    private  function deserialize_waveform(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return TL::extractWaveform($x);
        
    }
    private  function deserialize_random_bytes(mixed $stream): void {

            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                if ($l < 15) {
                    throw new SecurityException("Random_bytes is too small!");
                }
            } else {
                if ($l < 15) {
                    throw new SecurityException("Random_bytes is too small!");
                }
                $l += 1;
            }
            $resto = (-$l) % 4;
            $resto = $resto < 0 ? $resto + 4 : $resto;
            if ($resto > 0) {
                $l += $resto;
            }
            stream_get_contents($stream, $l);
        
    }
    private  function deserialize_type_array_of_int(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('l', stream_get_contents($stream, 4))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_long(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('q', stream_get_contents($stream, 8))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_double(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('d', stream_get_contents($stream, 8))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_strlong(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= stream_get_contents($stream, 8);
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_string(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= self::deserialize_string($stream);
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_bytes(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= self::deserialize_bytes($stream);
                }
                return $result;    
            
    }
    private  function deserialize_type_FileLocation(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_PhotoSize(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputStickerSet(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => $this->deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_MaskCoords(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'֮' => [
'_' => 'maskCoords',
'n' => unpack('l', stream_get_contents($stream, 4))[1],
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'zoom' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_MaskCoords(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_documentAttributeSticker(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeSticker'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['mask'] = ($flags & 2) !== 0;
$tmp['alt'] = self::deserialize_string($stream);
$tmp['stickerset'] = match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['mask_coords'] = match (stream_get_contents($stream, 4)) {
'֮' => [
'_' => 'maskCoords',
'n' => unpack('l', stream_get_contents($stream, 4))[1],
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'zoom' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MaskCoords(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_documentAttributeVideo(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeVideo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['round_message'] = ($flags & 1) !== 0;
$tmp['supports_streaming'] = ($flags & 2) !== 0;
$tmp['nosound'] = ($flags & 8) !== 0;
$tmp['duration'] = unpack('d', stream_get_contents($stream, 8))[1];
$tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['preload_prefix_size'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_documentAttributeAudio(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeAudio'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['voice'] = ($flags & 1024) !== 0;
$tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['performer'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['waveform'] = self::deserialize_waveform($stream);
return $tmp;

    }
    private  function deserialize_documentAttributeCustomEmoji(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeCustomEmoji'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['free'] = ($flags & 1) !== 0;
$tmp['text_color'] = ($flags & 2) !== 0;
$tmp['alt'] = self::deserialize_string($stream);
$tmp['stickerset'] = match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_documentAttributeVideo_66(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeVideo_66'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['round_message'] = ($flags & 1) !== 0;
$tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_DocumentAttribute(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'\\7l' => [
'_' => 'documentAttributeImageSize',
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'9' => [
'_' => 'documentAttributeAnimated',
],
'c' => self::deserialize_documentAttributeSticker($stream),
'' => self::deserialize_documentAttributeVideo($stream),
'R' => self::deserialize_documentAttributeAudio($stream),
'h' . "\0" . 'Y' => [
'_' => 'documentAttributeFilename',
'file_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'documentAttributeHasStickers',
],
'' => self::deserialize_documentAttributeCustomEmoji($stream),
'\'W
' => [
'_' => 'documentAttributeSticker_23',
],
'Y' => [
'_' => 'documentAttributeVideo_23',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'H' => [
'_' => 'documentAttributeAudio_23',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
],
'cU:' => [
'_' => 'documentAttributeSticker_45',
'alt' => self::deserialize_string($stream),
'stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'documentAttributeAudio_45',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'title' => self::deserialize_string($stream),
'performer' => self::deserialize_string($stream),
],
',' => self::deserialize_documentAttributeVideo_66($stream),
'r0' => $this->deserialize_type_DocumentAttribute(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_DecryptedMessageMedia(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_DecryptedMessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_DataJSON(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => $this->deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_SendMessageAction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'/' => [
'_' => 'sendMessageUploadVideoAction_17',
],
'o' => [
'_' => 'sendMessageUploadAudioAction_17',
],
'<
' => [
'_' => 'sendMessageUploadPhotoAction_17',
],
'鮏' => [
'_' => 'sendMessageUploadDocumentAction_17',
],
'$q' => [
'_' => 'sendMessageUploadRoundAction_66',
],
'r0' => $this->deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_DecryptedMessageAction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
':s' => [
'_' => 'decryptedMessageActionSetMessageTTL_8',
'ttl_seconds' => unpack('l', stream_get_contents($stream, 4))[1],
],
'@O' => [
'_' => 'decryptedMessageActionReadMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Cae' => [
'_' => 'decryptedMessageActionDeleteMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'u' => [
'_' => 'decryptedMessageActionScreenshotMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'\\g' => [
'_' => 'decryptedMessageActionFlushHistory_8',
],
'Q' => [
'_' => 'decryptedMessageActionResend_17',
'start_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
'end_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'decryptedMessageActionNotifyLayer_17',
'layer' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Av' => [
'_' => 'decryptedMessageActionTyping_17',
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'/' => [
'_' => 'sendMessageUploadVideoAction_17',
],
'o' => [
'_' => 'sendMessageUploadAudioAction_17',
],
'<
' => [
'_' => 'sendMessageUploadPhotoAction_17',
],
'鮏' => [
'_' => 'sendMessageUploadDocumentAction_17',
],
'$q' => [
'_' => 'sendMessageUploadRoundAction_66',
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'a' => [
'_' => 'decryptedMessageActionRequestKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a' => self::deserialize_bytes($stream),
],
'[so' => [
'_' => 'decryptedMessageActionAcceptKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'k' => [
'_' => 'decryptedMessageActionAbortKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'.' => [
'_' => 'decryptedMessageActionCommitKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'key_fingerprint' => stream_get_contents($stream, 8),
],
'c/' => [
'_' => 'decryptedMessageActionNoop_20',
],
'r0' => $this->deserialize_type_DecryptedMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageEntityMentionName(mixed $stream): mixed {
$tmp = [
'_' => 'messageEntityMentionName',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_type_InputPeer(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputUser(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_MessageEntity(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'messageEntityUnknown',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'W' => [
'_' => 'messageEntityMention',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
[co' => [
'_' => 'messageEntityHashtag',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ǌl' => [
'_' => 'messageEntityBotCommand',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'8%n' => [
'_' => 'messageEntityUrl',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ud' => [
'_' => 'messageEntityEmail',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'a' => [
'_' => 'messageEntityBold',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'`o' => [
'_' => 'messageEntityItalic',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q(' => [
'_' => 'messageEntityCode',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ks' => [
'_' => 'messageEntityPre',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'language' => self::deserialize_string($stream),
],
'\'Ӧv' => [
'_' => 'messageEntityTextUrl',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'url' => self::deserialize_string($stream),
],
'@{' => self::deserialize_messageEntityMentionName($stream),
'h ' => [
'_' => 'inputMessageEntityMentionName',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ki' => [
'_' => 'messageEntityPhone',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?tNL' => [
'_' => 'messageEntityCashtag',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'~N' => [
'_' => 'messageEntityUnderline',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ԓ' => [
'_' => 'messageEntityStrike',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'jv' => [
'_' => 'messageEntityBankCard',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'2' => [
'_' => 'messageEntitySpoiler',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'messageEntityCustomEmoji',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
' => [
'_' => 'messageEntityBlockquote',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MessageEntity(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_decryptedMessage_45(mixed $stream): mixed {
$tmp = ['_' => 'decryptedMessage_45'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['random_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['ttl'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['media'] = match (stream_get_contents($stream, 4)) {
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_DecryptedMessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2048) !== 0) $tmp['via_bot_name'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['reply_to_random_id'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_decryptedMessage_73(mixed $stream): mixed {
$tmp = ['_' => 'decryptedMessage_73'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['no_webpage'] = ($flags & 2) !== 0;
$tmp['silent'] = ($flags & 32) !== 0;
$tmp['random_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['ttl'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['media'] = match (stream_get_contents($stream, 4)) {
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_DecryptedMessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2048) !== 0) $tmp['via_bot_name'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['reply_to_random_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 131072) !== 0) $tmp['grouped_id'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    public  function deserialize_type_Object(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'O' => [
'_' => 'decryptedMessage_8',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'random_bytes' => self::deserialize_random_bytes($stream),
'message' => self::deserialize_string($stream),
'media' => match (stream_get_contents($stream, 4)) {
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_DecryptedMessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'}2H' => [
'_' => 'decryptedMessageService_8',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'random_bytes' => self::deserialize_random_bytes($stream),
'action' => match (stream_get_contents($stream, 4)) {
':s' => [
'_' => 'decryptedMessageActionSetMessageTTL_8',
'ttl_seconds' => unpack('l', stream_get_contents($stream, 4))[1],
],
'@O' => [
'_' => 'decryptedMessageActionReadMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Cae' => [
'_' => 'decryptedMessageActionDeleteMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'u' => [
'_' => 'decryptedMessageActionScreenshotMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'\\g' => [
'_' => 'decryptedMessageActionFlushHistory_8',
],
'Q' => [
'_' => 'decryptedMessageActionResend_17',
'start_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
'end_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'decryptedMessageActionNotifyLayer_17',
'layer' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Av' => [
'_' => 'decryptedMessageActionTyping_17',
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'/' => [
'_' => 'sendMessageUploadVideoAction_17',
],
'o' => [
'_' => 'sendMessageUploadAudioAction_17',
],
'<
' => [
'_' => 'sendMessageUploadPhotoAction_17',
],
'鮏' => [
'_' => 'sendMessageUploadDocumentAction_17',
],
'$q' => [
'_' => 'sendMessageUploadRoundAction_66',
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'a' => [
'_' => 'decryptedMessageActionRequestKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a' => self::deserialize_bytes($stream),
],
'[so' => [
'_' => 'decryptedMessageActionAcceptKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'k' => [
'_' => 'decryptedMessageActionAbortKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'.' => [
'_' => 'decryptedMessageActionCommitKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'key_fingerprint' => stream_get_contents($stream, 8),
],
'c/' => [
'_' => 'decryptedMessageActionNoop_20',
],
'r0' => self::deserialize_type_DecryptedMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'x8M ' => [
'_' => 'decryptedMessage_17',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'ttl' => unpack('l', stream_get_contents($stream, 4))[1],
'message' => self::deserialize_string($stream),
'media' => match (stream_get_contents($stream, 4)) {
'J\\' => [
'_' => 'decryptedMessageMediaEmpty_8',
],
'y2' => [
'_' => 'decryptedMessageMediaPhoto_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'nL' => [
'_' => 'decryptedMessageMediaVideo_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'Y
H5' => [
'_' => 'decryptedMessageMediaGeoPoint_8',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
],
'
X' => [
'_' => 'decryptedMessageMediaContact_8',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'user_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'KC' => [
'_' => 'decryptedMessageMediaDocument_8',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'file_name' => self::deserialize_string($stream),
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'u`' => [
'_' => 'decryptedMessageMediaAudio_8',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_DecryptedMessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`As' => [
'_' => 'decryptedMessageService_17',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'action' => match (stream_get_contents($stream, 4)) {
':s' => [
'_' => 'decryptedMessageActionSetMessageTTL_8',
'ttl_seconds' => unpack('l', stream_get_contents($stream, 4))[1],
],
'@O' => [
'_' => 'decryptedMessageActionReadMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Cae' => [
'_' => 'decryptedMessageActionDeleteMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'u' => [
'_' => 'decryptedMessageActionScreenshotMessages_8',
'random_ids' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'\\g' => [
'_' => 'decryptedMessageActionFlushHistory_8',
],
'Q' => [
'_' => 'decryptedMessageActionResend_17',
'start_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
'end_seq_no' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'decryptedMessageActionNotifyLayer_17',
'layer' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Av' => [
'_' => 'decryptedMessageActionTyping_17',
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'/' => [
'_' => 'sendMessageUploadVideoAction_17',
],
'o' => [
'_' => 'sendMessageUploadAudioAction_17',
],
'<
' => [
'_' => 'sendMessageUploadPhotoAction_17',
],
'鮏' => [
'_' => 'sendMessageUploadDocumentAction_17',
],
'$q' => [
'_' => 'sendMessageUploadRoundAction_66',
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'a' => [
'_' => 'decryptedMessageActionRequestKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a' => self::deserialize_bytes($stream),
],
'[so' => [
'_' => 'decryptedMessageActionAcceptKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'k' => [
'_' => 'decryptedMessageActionAbortKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'.' => [
'_' => 'decryptedMessageActionCommitKey_20',
'exchange_id' => unpack('q', stream_get_contents($stream, 8))[1],
'key_fingerprint' => stream_get_contents($stream, 8),
],
'c/' => [
'_' => 'decryptedMessageActionNoop_20',
],
'r0' => self::deserialize_type_DecryptedMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
']AJR' => [
'_' => 'decryptedMessageMediaVideo_17',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'˩W' => [
'_' => 'decryptedMessageMediaAudio_17',
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
],
'ݰ' => [
'_' => 'decryptedMessageMediaExternalDocument_23',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb' => match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'w' => [
'_' => 'photoSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'4' => [
'_' => 'photoCachedSize_23',
'type' => self::deserialize_string($stream),
'location' => match (stream_get_contents($stream, 4)) {
'FkY|' => [
'_' => 'fileLocationUnavailable_23',
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vS' => [
'_' => 'fileLocation_23',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'volume_id' => unpack('q', stream_get_contents($stream, 8))[1],
'local_id' => unpack('l', stream_get_contents($stream, 4))[1],
'secret' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_FileLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
,
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'ޑ6' => self::deserialize_decryptedMessage_45($stream),
'x' => [
'_' => 'decryptedMessageMediaPhoto_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaVideo_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'caption' => self::deserialize_string($stream),
],
'z' => [
'_' => 'decryptedMessageMediaDocument_45',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'o
' => [
'_' => 'decryptedMessageMediaVenue_45',
'lat' => unpack('d', stream_get_contents($stream, 8))[1],
'long' => unpack('d', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
],
'' => [
'_' => 'decryptedMessageMediaWebPage_45',
'url' => self::deserialize_string($stream),
],
'tF̑' => self::deserialize_decryptedMessage_73($stream),
'j' => [
'_' => 'decryptedMessageMediaDocument_143',
'thumb' => self::deserialize_bytes($stream),
'thumb_w' => unpack('l', stream_get_contents($stream, 4))[1],
'thumb_h' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'key' => self::deserialize_bytes($stream),
'iv' => self::deserialize_bytes($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_Object(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
}
