<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Stories
{
    /**
     * Check whether we can post stories as the specified peer.
     *
     * @param array|int|string $peer The peer from which we wish to post stories. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.canSendStoryCount', count_remains: int} @see https://docs.madelineproto.xyz/API_docs/types/stories.CanSendStoryCount.html
     */
    public function canSendStory(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Uploads a [Telegram Story](https://core.telegram.org/api/stories).
     *
     * @param bool $pinned Whether to add the story to the profile automatically upon expiration. If not set, the story will only be added to the archive, see [here »](https://core.telegram.org/api/stories) for more info.
     * @param bool $noforwards If set, disables forwards, screenshots, and downloads.
     * @param bool $fwd_modified Set this flag when reposting stories with `fwd_from_id`+`fwd_from_id`, if the `media` was modified before reposting.
     * @param array|int|string $peer The peer to send the story as. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media The story media. @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, title?: string, address?: string, provider?: string, venue_id?: string, venue_type?: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id?: int, result_id?: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2?: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark?: bool, flipped?: bool, reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id?: int, msg_id?: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel?: array|int|string, msg_id?: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url?: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji?: string, color?: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug?: string}> $media_areas Array of [Media areas](https://core.telegram.org/api/stories#media-areas) associated to the story, see [here »](https://core.telegram.org/api/stories#media-areas) for more info. @see https://docs.madelineproto.xyz/API_docs/types/MediaArea.html
     * @param string $caption Story caption.
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', collapsed?: bool, offset?: int, length?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of [Message entities for styled text](https://core.telegram.org/api/entities), if allowed by the [`stories_entities` client configuration parameter »](https://core.telegram.org/api/config#stories-entities). @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param list<array{_: 'inputPrivacyValueAllowContacts'}|array{_: 'inputPrivacyValueAllowAll'}|array{_: 'inputPrivacyValueAllowUsers', users?: list<array|int|string>}|array{_: 'inputPrivacyValueDisallowContacts'}|array{_: 'inputPrivacyValueDisallowAll'}|array{_: 'inputPrivacyValueDisallowUsers', users?: list<array|int|string>}|array{_: 'inputPrivacyValueAllowChatParticipants', chats?: list<int>}|array{_: 'inputPrivacyValueDisallowChatParticipants', chats?: list<int>}|array{_: 'inputPrivacyValueAllowCloseFriends'}|array{_: 'inputPrivacyValueAllowPremium'}|array{_: 'inputPrivacyValueAllowBots'}|array{_: 'inputPrivacyValueDisallowBots'}>|array<never, never> $privacy_rules Array of [Privacy rules](https://core.telegram.org/api/privacy) for the story, indicating who can or can't view the story. @see https://docs.madelineproto.xyz/API_docs/types/InputPrivacyRule.html
     * @param int $period Period after which the story is moved to archive (and to the profile if `pinned` is set), in seconds; must be one of `6 * 3600`, `12 * 3600`, `86400`, or `2 * 86400` for Telegram Premium users, and `86400` otherwise.
     * @param array|int|string $fwd_from_id If set, indicates that this story is a repost of story with ID `fwd_from_story` posted by the peer in `fwd_from_id`. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $fwd_from_story If set, indicates that this story is a repost of story with ID `fwd_from_story` posted by the peer in `fwd_from_id`.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendStory(bool|null $pinned = null, bool|null $noforwards = null, bool|null $fwd_modified = null, array|int|string|null $peer = null, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, array|null $media_areas = null, string|null $caption = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, array $privacy_rules = [], int|null $period = null, array|int|string|null $fwd_from_id = null, int|null $fwd_from_story = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit an uploaded [story](https://core.telegram.org/api/stories).
     *
     * @param array|int|string $peer Peer where the story was posted. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id ID of story to edit.
     * @param \danog\MadelineProto\EventHandler\Media|string|array $media If specified, replaces the story media. @see https://docs.madelineproto.xyz/API_docs/types/InputMedia.html
     * @param list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, title?: string, address?: string, provider?: string, venue_id?: string, venue_type?: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id?: int, result_id?: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2?: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark?: bool, flipped?: bool, reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id?: int, msg_id?: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel?: array|int|string, msg_id?: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url?: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji?: string, color?: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug?: string}> $media_areas Array of [Media areas](https://core.telegram.org/api/stories#media-areas) associated to the story, see [here »](https://core.telegram.org/api/stories#media-areas) for more info. @see https://docs.madelineproto.xyz/API_docs/types/MediaArea.html
     * @param string $caption If specified, replaces the story caption.
     * @param list<array{_: 'messageEntityUnknown', offset?: int, length?: int}|array{_: 'messageEntityMention', offset?: int, length?: int}|array{_: 'messageEntityHashtag', offset?: int, length?: int}|array{_: 'messageEntityBotCommand', offset?: int, length?: int}|array{_: 'messageEntityUrl', offset?: int, length?: int}|array{_: 'messageEntityEmail', offset?: int, length?: int}|array{_: 'messageEntityBold', offset?: int, length?: int}|array{_: 'messageEntityItalic', offset?: int, length?: int}|array{_: 'messageEntityCode', offset?: int, length?: int}|array{_: 'messageEntityPre', offset?: int, length?: int, language?: string}|array{_: 'messageEntityTextUrl', offset?: int, length?: int, url?: string}|array{_: 'messageEntityMentionName', offset?: int, length?: int, user_id?: int}|array{_: 'inputMessageEntityMentionName', offset?: int, length?: int, user_id?: array|int|string}|array{_: 'messageEntityPhone', offset?: int, length?: int}|array{_: 'messageEntityCashtag', offset?: int, length?: int}|array{_: 'messageEntityUnderline', offset?: int, length?: int}|array{_: 'messageEntityStrike', offset?: int, length?: int}|array{_: 'messageEntityBankCard', offset?: int, length?: int}|array{_: 'messageEntitySpoiler', offset?: int, length?: int}|array{_: 'messageEntityCustomEmoji', offset?: int, length?: int, document_id?: int}|array{_: 'messageEntityBlockquote', collapsed?: bool, offset?: int, length?: int}|array{_: 'messageEntityBlockquote', offset?: int, length?: int}> $entities Array of [Message entities for styled text in the caption](https://core.telegram.org/api/entities), if allowed by the [`stories_entities` client configuration parameter »](https://core.telegram.org/api/config#stories-entities). @see https://docs.madelineproto.xyz/API_docs/types/MessageEntity.html
     * @param \danog\MadelineProto\ParseMode $parse_mode Whether to parse HTML or Markdown markup in the message
     * @param list<array{_: 'inputPrivacyValueAllowContacts'}|array{_: 'inputPrivacyValueAllowAll'}|array{_: 'inputPrivacyValueAllowUsers', users?: list<array|int|string>}|array{_: 'inputPrivacyValueDisallowContacts'}|array{_: 'inputPrivacyValueDisallowAll'}|array{_: 'inputPrivacyValueDisallowUsers', users?: list<array|int|string>}|array{_: 'inputPrivacyValueAllowChatParticipants', chats?: list<int>}|array{_: 'inputPrivacyValueDisallowChatParticipants', chats?: list<int>}|array{_: 'inputPrivacyValueAllowCloseFriends'}|array{_: 'inputPrivacyValueAllowPremium'}|array{_: 'inputPrivacyValueAllowBots'}|array{_: 'inputPrivacyValueDisallowBots'}> $privacy_rules Array of If specified, alters the [privacy settings »](https://core.telegram.org/api/privacy) of the story, changing who can or can't view the story. @see https://docs.madelineproto.xyz/API_docs/types/InputPrivacyRule.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editStory(array|int|string|null $peer = null, int|null $id = 0, \danog\MadelineProto\EventHandler\Media|array|string|null $media = null, array|null $media_areas = null, string|null $caption = null, array|null $entities = null, \danog\MadelineProto\ParseMode $parse_mode = \danog\MadelineProto\ParseMode::TEXT, array|null $privacy_rules = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Deletes some posted [stories](https://core.telegram.org/api/stories).
     *
     * @param array|int|string $peer Channel/user from where to delete stories. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of stories to delete.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<int>
     */
    public function deleteStories(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Pin or unpin one or more stories.
     *
     * @param bool $pinned Whether to pin or unpin the stories
     * @param array|int|string $peer Peer where to pin or unpin stories @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of stories to pin or unpin
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<int>
     */
    public function togglePinned(bool $pinned, array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Fetch the List of active (or active and hidden) stories, see [here »](https://core.telegram.org/api/stories#watching-stories) for more info on watching stories.
     *
     * @param bool $next If `next` and `state` are both set, uses the passed `state` to paginate to the next results; if neither `state` nor `next` are set, fetches the initial page; if `state` is set and `next` is not set, check for changes in the active/hidden peerset, see [here »](https://core.telegram.org/api/stories#watching-stories) for more info on the full flow.
     * @param bool $hidden If set, fetches the hidden active story list, otherwise fetches the active story list, see [here »](https://core.telegram.org/api/stories#watching-stories) for more info on the full flow.
     * @param string $state If `next` and `state` are both set, uses the passed `state` to paginate to the next results; if neither `state` nor `next` are set, fetches the initial page; if `state` is set and `next` is not set, check for changes in the active/hidden peerset, see [here »](https://core.telegram.org/api/stories#watching-stories) for more info on the full flow.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.allStoriesNotModified', stealth_mode: array{_: 'storiesStealthMode', active_until_date?: int, cooldown_until_date?: int}, state: string}|array{_: 'stories.allStories', stealth_mode: array{_: 'storiesStealthMode', active_until_date?: int, cooldown_until_date?: int}, has_more: bool, count: int, state: string, peer_stories: list<array{_: 'peerStories', peer: array|int|string, max_read_id?: int, stories: list<array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.AllStories.html
     */
    public function getAllStories(bool|null $next = null, bool|null $hidden = null, string|null $state = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Fetch the [stories](https://core.telegram.org/api/stories#pinned-or-archived-stories) pinned on a peer's profile.
     *
     * @param array|int|string $peer Peer whose pinned stories should be fetched @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.stories', count: int, stories: list<array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, pinned_to_top?: list<int>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.Stories.html
     */
    public function getPinnedStories(array|int|string|null $peer = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Fetch the [story archive »](https://core.telegram.org/api/stories#pinned-or-archived-stories) of a peer we control.
     *
     * @param array|int|string $peer Peer whose archived stories should be fetched @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @param ?int $takeoutId Optional takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @return array{_: 'stories.stories', count: int, stories: list<array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, pinned_to_top?: list<int>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.Stories.html
     */
    public function getStoriesArchive(array|int|string|null $peer = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null, ?int $takeoutId = null): array;

    /**
     * Obtain full info about a set of [stories](https://core.telegram.org/api/stories) by their IDs.
     *
     * @param array|int|string $peer Peer where the stories were posted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Story IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.stories', count: int, stories: list<array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, pinned_to_top?: list<int>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.Stories.html
     */
    public function getStoriesByID(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Hide the active stories of a specific peer, preventing them from being displayed on the action bar on the homescreen.
     *
     * @param bool $hidden Whether to hide or unhide all active stories of the peer
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleAllStoriesHidden(bool $hidden, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Mark all stories up to a certain ID as read, for a given peer; will emit an [updateReadStories](https://docs.madelineproto.xyz/API_docs/constructors/updateReadStories.html) update to all logged-in sessions.
     *
     * @param array|int|string $peer The peer whose stories should be marked as read. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $max_id Mark all stories up to and including this ID as read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<int>
     */
    public function readStories(array|int|string|null $peer = null, int|null $max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Increment the view counter of one or more stories.
     *
     * @param array|int|string $peer Peer where the stories were posted. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of the stories (maximum 200 at a time).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function incrementStoryViews(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Obtain the list of users that have viewed a specific [story we posted](https://core.telegram.org/api/stories).
     *
     * @param bool $just_contacts Whether to only fetch view reaction/views made by our [contacts](https://core.telegram.org/api/contacts)
     * @param bool $reactions_first Whether to return [storyView](https://docs.madelineproto.xyz/API_docs/constructors/storyView.html) info about users that reacted to the story (i.e. if set, the server will first sort results by view date as usual, and then also additionally sort the list by putting [storyView](https://docs.madelineproto.xyz/API_docs/constructors/storyView.html)s with an associated reaction first in the list). Ignored if `forwards_first` is set.
     * @param bool $forwards_first If set, returns forwards and reposts first, then reactions, then other views; otherwise returns interactions sorted just by interaction date.
     * @param array|int|string $peer Peer where the story was posted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $q Search for specific peers
     * @param int $id Story ID
     * @param string $offset Offset for pagination, obtained from [stories.storyViewsList](https://docs.madelineproto.xyz/API_docs/constructors/stories.storyViewsList.html).`next_offset`
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.storyViewsList', count: int, views_count: int, forwards_count: int, reactions_count: int, views: list<array{_: 'storyView', blocked: bool, blocked_my_stories_from: bool, user_id: int, date: int, reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'storyViewPublicForward', blocked: bool, blocked_my_stories_from: bool, message: array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, hash: list<int|string>}, report_delivery_until_date?: int, paid_message_stars?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, reactions_are_possible: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: array, street_line2: array, city: array, state: array, country_iso2: array, post_code: array}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}|array{_: 'phoneCallDiscardReasonMigrateConferenceCall', slug: string}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: array, data_hash: array, secret: array}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, plain_data?: array{_: 'securePlainPhone', phone: array}|array{_: 'securePlainEmail', email: array}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributePattern', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributeBackdrop', name: array, backdrop_id: array, center_color: array, edge_color: array, pattern_color: array, text_color: array, rarity_permille: array}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array, sender_id?: array, date: array, message?: array}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, name_hidden: bool, saved: bool, converted: bool, upgraded: bool, refunded: bool, can_upgrade: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, convert_stars?: int, upgrade_msg_id?: int, upgrade_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int}|array{_: 'messageActionStarGiftUnique', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributePattern', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributeBackdrop', name: array, backdrop_id: array, center_color: array, edge_color: array, pattern_color: array, text_color: array, rarity_permille: array}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array, sender_id?: array, date: array, message?: array}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, upgrade: bool, transferred: bool, saved: bool, refunded: bool, can_export_at?: int, transfer_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int, resale_stars?: int, can_transfer_at?: int, can_resell_at?: int}|array{_: 'messageActionPaidMessagesRefunded', count: int, stars: int}|array{_: 'messageActionPaidMessagesPrice', stars: int}|array{_: 'messageActionConferenceCall', missed: bool, active: bool, video: bool, call_id: int, duration?: int, other_participants?: list<array|int|string>}, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, ttl_period?: int}}|array{_: 'storyViewPublicRepost', peer_id: array|int|string, story: array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}, blocked: bool, blocked_my_stories_from: bool}>, chats: list<array|int|string>, users: list<array|int|string>, next_offset?: string} @see https://docs.madelineproto.xyz/API_docs/types/stories.StoryViewsList.html
     */
    public function getStoryViewsList(bool|null $just_contacts = null, bool|null $reactions_first = null, bool|null $forwards_first = null, array|int|string|null $peer = null, string|null $q = null, int|null $id = 0, string|null $offset = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain info about the view count, forward count, reactions and recent viewers of one or more [stories](https://core.telegram.org/api/stories).
     *
     * @param array|int|string $peer Peer whose stories should be fetched @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id Story IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.storyViews', views: list<array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.StoryViews.html
     */
    public function getStoriesViews(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Generate a [story deep link](https://core.telegram.org/api/links#story-links) for a specific story.
     *
     * @param array|int|string $peer Peer where the story was posted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Story ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'exportedStoryLink', link: string} @see https://docs.madelineproto.xyz/API_docs/types/ExportedStoryLink.html
     */
    public function exportStoryLink(array|int|string|null $peer = null, int|null $id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a story.
     *
     * @param array|int|string $peer The peer that uploaded the story. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of the stories to report.
     * @param string $option Menu option, intially empty
     * @param string $message Comment for report moderation
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'reportResultChooseOption', title: string, options: list<array{_: 'messageReportOption', text: string, option: string}>}|array{_: 'reportResultAddComment', optional: bool, option: string}|array{_: 'reportResultReported'} @see https://docs.madelineproto.xyz/API_docs/types/ReportResult.html
     */
    public function report(array|int|string|null $peer = null, array $id = [], string|null $option = '', string|null $message = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Activates [stories stealth mode](https://core.telegram.org/api/stories#stealth-mode), see [here »](https://core.telegram.org/api/stories#stealth-mode) for more info.
     *
     * Will return an [updateStoriesStealthMode](https://docs.madelineproto.xyz/API_docs/constructors/updateStoriesStealthMode.html).
     *
     * @param bool $past Whether to erase views from any stories opened in the past [`stories_stealth_past_period` seconds »](https://core.telegram.org/api/config#stories-stealth-past-period), as specified by the [client configuration](https://core.telegram.org/api/config#client-configuration).
     * @param bool $future Whether to hide future story views for the next [`stories_stealth_future_period` seconds »](https://core.telegram.org/api/config#stories-stealth-future-period), as specified by the [client configuration](https://core.telegram.org/api/config#client-configuration).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function activateStealthMode(bool|null $past = null, bool|null $future = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * React to a story.
     *
     * @param bool $add_to_recent Whether to add this reaction to the [recent reactions list »](https://core.telegram.org/api/reactions#recent-reactions).
     * @param array|int|string $peer The peer that sent the story @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $story_id ID of the story to react to
     * @param array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}|array{_: 'reactionPaid'} $reaction Reaction @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function sendReaction(bool|null $add_to_recent = null, array|int|string|null $peer = null, int|null $story_id = 0, array|null $reaction = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Fetch the full active [story list](https://core.telegram.org/api/stories#watching-stories) of a specific peer.
     *
     * @param array|int|string $peer Peer whose stories should be fetched @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.peerStories', stories: array{_: 'peerStories', peer: array|int|string, max_read_id?: int, stories: list<array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>}, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.PeerStories.html
     */
    public function getPeerStories(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain the latest read story ID for all peers when first logging in, returned as a list of [updateReadStories](https://docs.madelineproto.xyz/API_docs/constructors/updateReadStories.html) updates, see [here »](https://core.telegram.org/api/stories#watching-stories) for more info.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getAllReadPeerStories(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get the IDs of the maximum read stories for a set of peers.
     *
     * @param list<array|int|string>|array<never, never> $id Array of Peers @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return list<int>
     */
    public function getPeerMaxIDs(array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain a list of channels where the user can post [stories](https://core.telegram.org/api/stories).
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getChatsToSend(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Hide the active stories of a user, preventing them from being displayed on the action bar on the homescreen, see [here »](https://core.telegram.org/api/stories#hiding-stories-of-other-users) for more info.
     *
     * @param bool $hidden Whether to hide or unhide stories.
     * @param array|int|string $peer Peer whose stories should be (un)hidden. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function togglePeerStoriesHidden(bool $hidden, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get the [reaction](https://core.telegram.org/api/reactions) and interaction list of a [story](https://core.telegram.org/api/stories) posted to a channel, along with the sender of each reaction.
     *
     * Can only be used by channel admins.
     *
     * @param bool $forwards_first If set, returns forwards and reposts first, then reactions, then other views; otherwise returns interactions sorted just by interaction date.
     * @param array|int|string $peer Channel @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id [Story](https://core.telegram.org/api/stories) ID
     * @param array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}|array{_: 'reactionPaid'} $reaction Get only reactions of this type @see https://docs.madelineproto.xyz/API_docs/types/Reaction.html
     * @param string $offset Offset for pagination (taken from the `next_offset` field of the returned [stories.StoryReactionsList](https://docs.madelineproto.xyz/API_docs/types/stories.StoryReactionsList.html)); empty in the first request.
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.storyReactionsList', count: int, reactions: list<array{_: 'storyReaction', peer_id: array|int|string, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'storyReactionPublicForward', message: array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, hash: list<int|string>}, report_delivery_until_date?: int, paid_message_stars?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, reactions_are_possible: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: array, street_line2: array, city: array, state: array, country_iso2: array, post_code: array}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}|array{_: 'phoneCallDiscardReasonMigrateConferenceCall', slug: string}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: array, data_hash: array, secret: array}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, plain_data?: array{_: 'securePlainPhone', phone: array}|array{_: 'securePlainEmail', email: array}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributePattern', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributeBackdrop', name: array, backdrop_id: array, center_color: array, edge_color: array, pattern_color: array, text_color: array, rarity_permille: array}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array, sender_id?: array, date: array, message?: array}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, name_hidden: bool, saved: bool, converted: bool, upgraded: bool, refunded: bool, can_upgrade: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, convert_stars?: int, upgrade_msg_id?: int, upgrade_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int}|array{_: 'messageActionStarGiftUnique', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributePattern', name: array, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: array}|array{_: 'starGiftAttributeBackdrop', name: array, backdrop_id: array, center_color: array, edge_color: array, pattern_color: array, text_color: array, rarity_permille: array}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array, sender_id?: array, date: array, message?: array}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, upgrade: bool, transferred: bool, saved: bool, refunded: bool, can_export_at?: int, transfer_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int, resale_stars?: int, can_transfer_at?: int, can_resell_at?: int}|array{_: 'messageActionPaidMessagesRefunded', count: int, stars: int}|array{_: 'messageActionPaidMessagesPrice', stars: int}|array{_: 'messageActionConferenceCall', missed: bool, active: bool, video: bool, call_id: int, duration?: int, other_participants?: list<array|int|string>}, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, ttl_period?: int}}|array{_: 'storyReactionPublicRepost', peer_id: array|int|string, story: array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}}>, chats: list<array|int|string>, users: list<array|int|string>, next_offset?: string} @see https://docs.madelineproto.xyz/API_docs/types/stories.StoryReactionsList.html
     */
    public function getStoryReactionsList(bool|null $forwards_first = null, array|int|string|null $peer = null, int|null $id = 0, array|null $reaction = null, string|null $offset = null, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Pin some stories to the top of the profile, see [here »](https://core.telegram.org/api/stories#pinned-or-archived-stories) for more info.
     *
     * @param array|int|string $peer Peer where to pin stories. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of the stories to pin (max [stories\_pinned\_to\_top\_count\_max](https://core.telegram.org/api/config#stories-pinned-to-top-count-max)).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function togglePinnedToTop(array|int|string|null $peer = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Globally search for [stories](https://core.telegram.org/api/stories) using a hashtag or a [location media area](https://core.telegram.org/api/stories#location-tags), see [here »](https://core.telegram.org/api/stories#searching-stories) for more info on the full flow.
     *
     * Either `hashtag` **or** `area` **must** be set when invoking the method.
     *
     * @param string $hashtag Hashtag (without the `#`)
     * @param array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, title?: string, address?: string, provider?: string, venue_id?: string, venue_type?: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id?: int, result_id?: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo?: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash?: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2?: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark?: bool, flipped?: bool, reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon?: string}|array{_: 'reactionCustomEmoji', document_id?: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id?: int, msg_id?: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel?: array|int|string, msg_id?: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url?: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji?: string, color?: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug?: string} $area A [mediaAreaGeoPoint](https://docs.madelineproto.xyz/API_docs/constructors/mediaAreaGeoPoint.html) or a [mediaAreaVenue](https://docs.madelineproto.xyz/API_docs/constructors/mediaAreaVenue.html).  <br>Note [mediaAreaGeoPoint](https://docs.madelineproto.xyz/API_docs/constructors/mediaAreaGeoPoint.html) areas may be searched only if they have an associated `address`. @see https://docs.madelineproto.xyz/API_docs/types/MediaArea.html
     * @param array|int|string $peer If set, returns only stories posted by this peer. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $offset Offset for [pagination](https://core.telegram.org/api/offsets): initially an empty string, then the `next_offset` from the previously returned [stories.foundStories](https://docs.madelineproto.xyz/API_docs/constructors/stories.foundStories.html).
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stories.foundStories', count: int, stories: list<array{_: 'foundStory', peer: array|int|string, story: array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}|array{_: 'mediaAreaStarGift', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, slug: string}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}}>, next_offset?: string, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stories.FoundStories.html
     */
    public function searchPosts(string|null $hashtag = null, array|null $area = null, array|int|string|null $peer = null, string|null $offset = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;
}
