<?php declare(strict_types=1);

/**
 * This file is part of MadelineProto.
 * MadelineProto is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * MadelineProto is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU General Public License along with MadelineProto.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * @author    Daniil Gentili <daniil@daniil.it>
 * @copyright 2016-2025 Daniil Gentili <daniil@daniil.it>
 * @license   https://opensource.org/licenses/AGPL-3.0 AGPLv3
 * @link https://docs.madelineproto.xyz MadelineProto documentation
 */

namespace danog\MadelineProto\EventHandler\Message\Service;

use danog\MadelineProto\EventHandler\Message\ServiceMessage;
use danog\MadelineProto\EventHandler\Wallpaper;
use danog\MadelineProto\MTProto;

/**
 * The [wallpaper](https://core.telegram.org/api/wallpapers) of the current chat was changed.
 */
final class DialogSetChatWallPaper extends ServiceMessage
{
    public function __construct(
        MTProto $API,
        array $rawMessage,
        array $info,

        /** @var Wallpaper New [wallpaper](https://core.telegram.org/api/wallpapers) */
        public readonly Wallpaper $wallpaper,

        /** @var bool Whether the user applied a wallpaper previously sent by the other user in a DialogSetChatWallPaper message. */
        public readonly bool $same = false
    ) {
        parent::__construct($API, $rawMessage, $info);
    }
}
